// priority: 1000
//Read the gamemode configuration file for use in other scripts
global.gamemodeFile = JsonIO.read("gamemode.json");

//Tiers of Mystical Agriculture seeds and their respective soil to grow on.
global.seedTiers = [
    tier1 = {
        seeds: [
            "earth",
            "water",
            "fire",
            "inferium",
            "stone",
            "dirt",
            "wood",
            "ice",
            "deepslate",
            "runewood"
        ],
        soil: "mysticalagriculture:inferium_farmland"
    },
    tier2 = {
        seeds: [
            "nature",
            "dye",
            "nether",
            "coal",
            "coral",
            "honey",
            "amethyst",
            "pig",
            "chicken",
            "cow",
            "sheep",
            "squid",
            "fish",
            "slime",
            "turtle",
            "silicon",
            "sulfur",
            "aluminum",
            "saltpeter",
            "limestone",
            "basalt",
            "archwood",
            "mystical_flower",
            "apatite",
            "rubber"
        ],
        soil: "mysticalagriculture:prudentium_farmland"
    },
    tier3 = {
        seeds: [
            "iron",
            "copper",
            "nether_quartz",
            "glowstone",
            "redstone",
            "obsidian",
            "prismarine",
            "zombie",
            "skeleton",
            "creeper",
            "spider",
            "rabbit",
            "zinc",
            "brass",
            "silver",
            "lead",
            "amethyst_bronze",
            "slimesteel",
            "pig_iron",
            "sky_stone",
            "certus_quartz",
            "source_gem",
            "manasteel",
            "bronze",
            "tin",
            "blizz",
            "blitz",
            "basalz",
            "aquamarine"
        ],
        soil: "mysticalagriculture:tertium_farmland"
    },
    tier4 = {
        seeds: [
            "gold",
            "lapis_lazuli",
            "end",
            "experience",
            "blaze",
            "ghast",
            "enderman",
            "steel",
            "nickel",
            "constantan",
            "electrum",
            "uranium",
            "hop_graphite",
            "rose_gold",
            "fluix",
            "hallowed_gold",
            "cobalt",
            "elementium",
            "osmium",
            "fluorite",
            "refined_glowstone",
            "refined_obsidian",
            "compressed_iron",
            "invar",
            "lumium",
            "signalum",
            "sapphire",
            "ruby",
            "iesnium"
        ],
        soil: "mysticalagriculture:imperium_farmland"
    },
    tier5 = {
        seeds: [
            "diamond",
            "emerald",
            "netherite",
            "wither_skeleton",
            "queens_slime",
            "hepatizon",
            "soul_stained_steel",
            "manyullyn",
            "terrasteel",
            "enderium"
        ],
        soil: "mysticalagriculture:supremium_farmland"
    }
]

//All Minecraft dyes
global.dyes = ['white', 'orange', 'magenta', 'light_blue', 'yellow', 'lime', 'pink', 'gray', 'light_gray', 'cyan', 'purple', 'blue', 'brown', 'green', 'red', 'black'];

//Simple item crushing, one input, one output.
//Only works with item IDs
global.simpleSingleItemCrushing = (output, input, event) => {
    //Create crushing
    event.recipes.createCrushing([output], input)
    //Immersive Engineering crushing
    event.recipes.immersiveengineering.crusher(output, input);
    //Mekanism crushing
    event.custom({
        "type": "mekanism:crushing",
        "input": {
            "ingredient": {
                "item": input
            }
        },
        "output": {
            "item": output
        }
    });
}

//Garden Cloche crop soils
//Used in immersive engineering script and also tooltips
//Multiple blocks -> [{'item':'minecraft:mycelium'},{'item':'minecraft:podzol'}]
//Single block -> {'item':'minecraft:dirt'}
global.soils = {
    dirt: {
        bundle: {'item':'minecraft:dirt'},
        timeModifier: 1
    },
    grass_block: {
        bundle: {'item':'minecraft:grass_block'},
        timeModifier: 0.9
    },
    vivid_grass: {
        bundle: {'item':'botania:vivid_grass'},
        timeModifier: 0.8
    },
    phytosoil: {
        bundle: {'item':'thermal:phytosoil'},
        timeModifier: 0.7
    },
    rich_soil: {
        bundle: {'item':'farmersdelight:rich_soil'},
        timeModifier: 0.6
    },
    enchanted_soil: {
        bundle: {'item':'botania:enchanted_soil'},
        timeModifier: 0.5
    },
    dry_grass: {
        bundle: {'item':'botania:dry_grass'},
        timeModifier: 0.9
    },
    rooted_dirt: {
        bundle: {'item':'minecraft:rooted_dirt'},
        timeModifier: 1
    },
    podzol: {
        bundle: {'item':'minecraft:podzol'},
        timeModifier: 0.9
    },
    mycelium: {
        bundle: {'item':'minecraft:mycelium'},
        timeModifier: 0.8
    },
    mutated_grass: {
        bundle: {'item':'botania:mutated_grass'},
        timeModifier: 0.8
    },
    glowing_moss: {
        bundle: {'item':'biomesoplenty:glowing_moss_block'},
        timeModifier: 1
    },
    tube_coral: {
        bundle: {'item':'minecraft:tube_coral_block'},
        timeModifier: 1
    },
    brain_coral: {
        bundle: {'item':'minecraft:brain_coral_block'},
        timeModifier: 1
    },
    bubble_coral: {
        bundle: {'item':'minecraft:bubble_coral_block'},
        timeModifier: 1
    },
    fire_coral: {
        bundle: {'item':'minecraft:fire_coral_block'},
        timeModifier: 1
    },
    horn_coral: {
        bundle: {'item':'minecraft:horn_coral_block'},
        timeModifier: 1
    },
    soul_sand: {
        bundle: {'item':'minecraft:soul_sand'},
        timeModifier: 1
    },
    scorched_grass: {
        bundle: {'item':'botania:scorched_grass'},
        timeModifier: 0.8
    },
    netherrack: {
        bundle: {'item':'minecraft:netherrack'},
        timeModifier: 1
    },
    end_stone: {
        bundle: {'item':'minecraft:end_stone'},
        timeModifier: 1
    },
    infused_grass: {
        bundle: {'item':'botania:infused_grass'},
        timeModifier: 0.8
    },
    wet_sponge: {
        bundle: {'item':'minecraft:wet_sponge'},
        timeModifier: 1
    },
    sand: {
        bundle: {'tag':'forge:sand'},
        timeModifier: 1
    },
    rooted_sand: {
        bundle: {'item':'biomesoplenty:rooted_sand'},
        timeModifier: 0.8
    },
    crimson_nylium: {
        bundle: {'item':'minecraft:crimson_nylium'},
        timeModifier: 1
    },
    warped_nylium: {
        bundle: {'item':'minecraft:warped_nylium'},
        timeModifier: 1
    },
    snad: {
        bundle: {'item':'snad:snad'},
        timeModifier: 0.8
    },
    red_snad: {
        bundle: {'item':'snad:red_snad'},
        timeModifier: 0.8
    },
    suol_snad: {
        bundle: {'item':'snad:suol_snad'},
        timeModifier: 0.8
    },
    budding_earthslime: {
        bundle: {'item':'tconstruct:budding_earth_slime_crystal'},
        timeModifier: 1.0
    },
    budding_skyslime: {
        bundle: {'item':'tconstruct:budding_sky_slime_crystal'},
        timeModifier: 1.0
    },
    budding_ichorslime: {
        bundle: {'item':'tconstruct:budding_ichor_slime_crystal'},
        timeModifier: 1.0
    },
    budding_enderslime: {
        bundle: {'item':'tconstruct:budding_ender_slime_crystal'},
        timeModifier: 1.0
    },
    budding_amethyst: {
        bundle: {'item':'minecraft:budding_amethyst'},
        timeModifier: 1.0
    }
};